// Header File
// Created 07/11/2003; 21:57:58
//Fonctions dessins map

void InitCounterBricks (void);

void MAP_InitSpecialBricks_TIME (void);
void MAP_InitSpecialBricks_MOVE (void);

void MAP_ShowSpecialBricks_MOVE (void);

//y max=132 soit 132+8=140
//Largeur en octet=28 octets
#define BufferMap_SIZEPLAN							3724
#define BufferMap_SIZE									7448

static unsigned char COUNTER_BRICKS=0;

void *BufferMap=NULL;
static unsigned char LevelMap [18][13]={};

//Variables briques spcial TIME
static unsigned short bricks_special_time_n;
static unsigned char MAP_bricks_special_time_x [100];
static unsigned char MAP_bricks_special_time_y [100];
static unsigned short MAP_bricks_special_time_c [100];

//Variables briques spcial TIME
static unsigned short bricks_special_move_n;
static unsigned char MAP_bricks_special_move_x [20];
static unsigned char MAP_bricks_special_move_y [20];
static char MAP_bricks_special_move_dir [20];
static BOOL MAP_bricks_special_move_destroy [20];
static unsigned char MAP_bricks_special_move_sprite [20];
static BOOL MAP_bricks_special_move_dep [20];

#define MAP_BRICK_TIME									20
#define __MAP_FREQUENCY_TIME						128
unsigned short __MAP_COUNTER_TIME=0;

#define MAP_BRICKS_MOVE									15 //Hz
#define __MAP_FREQUENCY_MOVE						1927
unsigned short __MAP_COUNTER_MOVE=0;

//Save ScreenBuffer to BufferMap
void CopyScreenToBufferMap (register void *src asm("%a0"),
		      								 	register void *dest asm("%a1"));

//Copy BufferMap to ScreenBuffer
void CopyBufferMapToScreen (register void *src asm("%a0"),
					                  register void *dest asm("%a1"));


//Copie la carte dans le buffer LevelMap
//void SetMap (unsigned char map[18][13]) {memcpy(LevelMap,map,234);}	//18*13

//Initalisation du Buffer Map et de LevelMap
void InitBufferMap (void)
{
	//Compteur de briques
	InitCounterBricks ();
	
	//Briques spcial
	MAP_InitSpecialBricks_MOVE ();
	MAP_InitSpecialBricks_TIME ();
	
	//Compteur de temps MAP briques spcial
  __MAP_COUNTER_TIME=0;
  
  MAP_StartInt1=TRUE;
}

//Dessine matrice map
void DrawMap ()
{
	short x=START_X, y=START_Y;
	unsigned char block;
	
	//y matrix
	for (int j=0;j<18;j++)
	{
		//x matrix
		for (int i=0;i<13;i++)
		{
			block=LevelMap[j][i]&0x0F;
			
			if (LevelMap[j][i]&0x0F) DrawBlock (x,y,SPRITE_BLOCKS [block],ScreenBuffer);
			x+=16;
		}
		
		y+=7;
		x=8;
	}
}

//Dessine bout de background (casse brique)
void DrawMapBackground (unsigned char xblock, unsigned char yblock)
{
	short x=(xblock*BLOCK_SIZEX)+START_X;
	short y=yblock*BLOCK_SIZEY;
		
	//Modulo 2 block*2 octets
	unsigned char xoffset=((xblock&0x01)^1)*2+1;
	
	//(y-Numro du sprite*32)*16 octets 			Numro du sprite=(y-Dbut)/Size y
	unsigned short yoffset=0;
	
	//Si y est diffrent de 0
	if (y) yoffset=(y-((y-BLOCK_SIZEY) & 0xE0))*16;
	
	//Dessine Small background (Dtruit brique)
	DrawSmallBackground (x,y,xoffset+yoffset,DecorsBlocks,BufferMap);
	
	//Dtruire ombre bas
	y+=BLOCK_SIZEY;
	yoffset=(y-((y-START_Y) & 0xE0))*16;
	
	//Si y=tout en haut
	if (y==BLOCK_SIZEY)	yoffset=7*16;
	
	DrawSmallBackground (x,y,xoffset+yoffset,DecorsBlocks,BufferMap);
	
	//Dtruire ombre bas droite
	if ((xblock+1)!=13)
	{
		xoffset=(((xblock+1)&0x01)^1)*2+1;
		DrawSmallBackground (x+16,y,xoffset+yoffset,DecorsBlocks,BufferMap);
	}
	
	//Redessine briques
	if (((yblock+1)!=18) && (LevelMap [yblock+1][xblock]&0x0F))
		DrawBlockNoShadow (x,y,SPRITE_BLOCKS [LevelMap [yblock+1][xblock]&0x0F],BufferMap);
		
	if (((xblock+1)!=13) && ((yblock+1)!=18) && (LevelMap [yblock+1][xblock+1]&0x0F))
		DrawBlockNoShadow (x+BLOCK_SIZEX,y,SPRITE_BLOCKS [LevelMap [yblock+1][xblock+1]&0x0F],BufferMap);
		
	//Ombres
	if (CST_SHADOW) 
	{
		y-=BLOCK_SIZEY;
		if (((yblock-1)>=0) && (LevelMap [yblock-1][xblock]&0x0F))
			_DrawSmallShadowBlock (x+8,y,BufferMap);
		
		if (((xblock-1)>=0) && ((yblock-1)>=0) && (LevelMap [yblock-1][xblock-1]&0x0F))
			_DrawSmallShadowBlock (x,y,BufferMap);
	
		if (((xblock-1)>=0) && (LevelMap [yblock][xblock-1]&0x0F) && ((!LevelMap [yblock+1][xblock]&0x0F) || (((yblock+1)==18))))
			_DrawSmallShadowBlock (x,y+7,BufferMap);
		
		if (((xblock+1)!=13) && (LevelMap [yblock][xblock+1]&0x0F) && ((!LevelMap [yblock+1][xblock+1]&0x0F) || (((yblock+1)==18))))
			_DrawSmallShadowBlock (x+BLOCK_SIZEX+8,y+BLOCK_SIZEY,BufferMap);
	}	
	
	//Dessine ombre gauche
	if (!xblock)
	{
		_DrawSmallShadowBlock (x,y,BufferMap);
		
		if (((yblock+1)==18) || (!LevelMap [yblock+1][xblock]&0x0F))
			DrawSmallShadowBlock (x,y+BLOCK_SIZEY,BufferMap);
		
		if (!CST_SHADOW)
		  _DrawSmallShadowBlock (x,y-BLOCK_SIZEY,BufferMap);
	}
	
	//Dessine ombre du haut
	if (!yblock)
	{
		if (xblock)	_DrawSmallShadowBlock (x,0,BufferMap);
		  _DrawSmallShadowBlock (x+8,0,BufferMap);
	}
}

//Initialisation du compteur de briques.
void InitCounterBricks (void)
{
	//Compteur briques  0
	COUNTER_BRICKS=0;

	//y matrix
	for (int j=0;j<18;j++)
	{
		//x matrix
		for (int i=0;i<13;i++)
		{
			//Si diffrent de 0 ou diffrent de brique spcial TIME ou diffrent de 0x08
			if ((LevelMap [j][i]&0x0F) && ((LevelMap [j][i]&0x0F)!=0x0B) && ((LevelMap [j][i]&0x0F)!=0x08))
				COUNTER_BRICKS++;
		}
	}
	
	//Scnarios ferme passage niveau suivant
	if (!COUNTER_BRICKS && MAP_SCENARIO) COUNTER_BRICKS=1;
}

//Redessine map
void MAP_ReDrawMap (void)
{
	DrawScreen (SPRITE_DECORS [C_DECORS],ScreenBuffer);
  DrawScreenShadow (ScreenBuffer);
	DrawMap ();
	DrawSquareSide (SPRITE_SQUARE_left_and_right,ScreenBuffer);
	CopyScreenToBufferMap (ScreenBuffer,BufferMap);
	
	MAP_ShowSpecialBricks_MOVE ();
}

//Affiche brique cass spcial
void MAP_ShowSpecialBricks_TIME (void)
{
	BOOL ReDrawMap=FALSE;
	
	//Briques spcial TIME
	for (unsigned short i=0;i<bricks_special_time_n;i++)
	{
		//Si brique cass et compteur suprieur
		if (((LevelMap [MAP_bricks_special_time_y[i]][MAP_bricks_special_time_x[i]]&0x0F)==0) && (MAP_bricks_special_time_c[i]>=MAP_BRICK_TIME))
		{
			MAP_bricks_special_time_c[i]=0;
			
			LevelMap [MAP_bricks_special_time_y[i]][MAP_bricks_special_time_x[i]]=0x0B;
			
			ReDrawMap=TRUE;
		}
	}
	
	//Redessine map
	if (ReDrawMap) MAP_ReDrawMap ();
}

//Initialise bricks time
void MAP_InitSpecialBricks_TIME (void)
{
	bricks_special_time_n=0;
	
	//Spcial dpendant du temps
	for (int j=0;j<18;j++)
	{
		for (int i=0;i<13;i++)
		{
			//Si brique spcial
			if ((LevelMap [j][i]&0x0F)==0x0B)
			{
				//Brique dans matrice				
				MAP_bricks_special_time_x [bricks_special_time_n]=i;
				MAP_bricks_special_time_y [bricks_special_time_n]=j;
				
				//Brique compteur
				MAP_bricks_special_time_c [bricks_special_time_n++]=0;
				
				//Dpasseement de cpacit
				if (bricks_special_time_n>=100) return;
			}
		}
	}
}

//Initialise bricks move
void MAP_InitSpecialBricks_MOVE (void)
{
	short rand_nbr;
	unsigned char block;
	
	bricks_special_move_n=0;
	
	//Parcours MAP
	for (int j=0;j<18;j++)
	{
		for (int i=0;i<13;i++)
		{
			//Si brique MOVE
			if ((LevelMap [j][i]&B_MOVE)!=0)
			{
				//Rcuprer brique
				block=LevelMap [j][i]&0x0F;
				
				//Extraction du sprite
				MAP_bricks_special_move_sprite [bricks_special_move_n]=LevelMap [j][i]&0x0F;
				
				//Enleve brique
				LevelMap [j][i]=0;
				
				MAP_bricks_special_move_x [bricks_special_move_n]=(i*BLOCK_SIZEX)+START_X;
				MAP_bricks_special_move_y [bricks_special_move_n]=(j*BLOCK_SIZEY)+START_Y;
				
				rand_nbr=GCL_Random (2); 
				if (rand_nbr==0) rand_nbr=-1;
				else rand_nbr=1;
				
				MAP_bricks_special_move_dir [bricks_special_move_n]=rand_nbr;
				
				//Non dtruite
				MAP_bricks_special_move_destroy [bricks_special_move_n]=FALSE;
				
				//Briques spcial
				if ((block==0x06) || (block==0x08) || (block==0x0B))
					MAP_bricks_special_move_dep [bricks_special_move_n++]=FALSE;
				else
					MAP_bricks_special_move_dep [bricks_special_move_n++]=TRUE;
					
				//Dpasseement de cpacit
				if (bricks_special_move_n>=20) return;
			}
		}
	}
}

//Affiche briques spcial
void MAP_ShowSpecialBricks_MOVE (void)
{
	for (unsigned short i=0;i<bricks_special_move_n;i++)
	{
		if (!MAP_bricks_special_move_destroy [i])
			DrawBlockMove (MAP_bricks_special_move_x [i],MAP_bricks_special_move_y [i],SPRITE_BLOCKS[MAP_bricks_special_move_sprite[i]&0x0F],ScreenBuffer);
	}
}